<?php
require_once __DIR__ . '/../config/db.php';

try {
    // Create payments table
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS payments (
            id INT AUTO_INCREMENT PRIMARY KEY,
            invoice_id INT NOT NULL,
            payment_method VARCHAR(50) NOT NULL,
            payment_date DATE NOT NULL,
            amount DECIMAL(10,2) NOT NULL,
            reference_number VARCHAR(100),
            notes TEXT,
            processed_by INT NOT NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (invoice_id) REFERENCES invoices(id) ON DELETE CASCADE,
            FOREIGN KEY (processed_by) REFERENCES users(id) ON DELETE RESTRICT,
            INDEX idx_invoice_id (invoice_id),
            INDEX idx_payment_date (payment_date),
            INDEX idx_payment_method (payment_method)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");

    echo "✅ Payments table created successfully!\n";
    echo "📋 Table created:\n";
    echo "   - payments (payment records)\n";
    echo "\n🔗 Foreign key relationships:\n";
    echo "   - payments.invoice_id → invoices.id\n";
    echo "   - payments.processed_by → users.id\n";
    echo "\n📊 Payment methods supported:\n";
    echo "   - Cash\n";
    echo "   - M-Pesa\n";
    echo "   - Bank Transfer\n";
    echo "   - Cheque\n";
    echo "   - Credit Card\n";
    echo "   - Other\n";

} catch (PDOException $e) {
    echo "❌ Error creating payments table: " . $e->getMessage() . "\n";
} 